<?php
/**
 * Script para verificar e corrigir configurações do velozpay
 * Execute este arquivo no navegador para verificar as configurações atuais
 */

// Carregar WordPress
require_once('../../../wp-config.php');

echo "<h1>🔍 Verificação das Configurações do velozpay</h1>";

// Verificar configurações do WooCommerce
echo "<h2>📋 Configurações do WooCommerce Gateway:</h2>";
$wc_settings = get_option('woocommerce_pix_gateway_settings', array());

if (!empty($wc_settings)) {
    echo "<p>✅ Configurações encontradas:</p>";
    echo "<pre>" . print_r($wc_settings, true) . "</pre>";
    
    // Verificar se a URL antiga está sendo usada
    if (isset($wc_settings['api_url']) && strpos($wc_settings['api_url'], 'gateway.stackcode.com.br') !== false) {
        echo "<p>❌ <strong>PROBLEMA ENCONTRADO:</strong> URL antiga ainda está configurada!</p>";
        echo "<p>URL atual: " . esc_html($wc_settings['api_url']) . "</p>";
        
        // Atualizar para a nova URL
        $wc_settings['api_url'] = 'https://velozpay.online/api/v1/gateway/processa_pagamento_api.php';
        update_option('woocommerce_pix_gateway_settings', $wc_settings);
        echo "<p>✅ <strong>CORRIGIDO:</strong> URL atualizada para: " . esc_html($wc_settings['api_url']) . "</p>";
    } else {
        echo "<p>✅ URL da API está correta: " . esc_html($wc_settings['api_url'] ?? 'Não configurada') . "</p>";
    }
} else {
    echo "<p>❌ Configurações do gateway não encontradas</p>";
}

// Verificar configurações diretas do plugin
echo "<h2>🔧 Configurações Diretas do Plugin:</h2>";
$api_url_direct = get_option('wc_pix_gateway_api_url', '');
$api_key_direct = get_option('wc_pix_gateway_api_key', '');

echo "<p>URL da API (direta): " . esc_html($api_url_direct ?: 'Não configurada') . "</p>";
echo "<p>API Key (direta): " . esc_html($api_key_direct ?: 'Não configurada') . "</p>";

if ($api_url_direct && strpos($api_url_direct, 'gateway.stackcode.com.br') !== false) {
    echo "<p>❌ <strong>PROBLEMA ENCONTRADO:</strong> URL antiga nas configurações diretas!</p>";
    
    // Atualizar para a nova URL
    update_option('wc_pix_gateway_api_url', 'https://velozpay.online/api/v1/gateway/processa_pagamento_api.php');
    echo "<p>✅ <strong>CORRIGIDO:</strong> URL atualizada nas configurações diretas</p>";
}

// Verificar se há outras opções com URL antiga
echo "<h2>🔍 Busca por Outras Referências:</h2>";
global $wpdb;

$results = $wpdb->get_results("
    SELECT option_name, option_value 
    FROM {$wpdb->options} 
    WHERE option_value LIKE '%gateway.stackcode.com.br%'
");

if (!empty($results)) {
    echo "<p>❌ <strong>PROBLEMAS ENCONTRADOS:</strong> Outras referências à URL antiga:</p>";
    foreach ($results as $result) {
        echo "<p>• " . esc_html($result->option_name) . ": " . esc_html($result->option_value) . "</p>";
        
        // Atualizar automaticamente
        $new_value = str_replace('gateway.stackcode.com.br', 'velozpay.io', $result->option_value);
        update_option($result->option_name, $new_value);
        echo "<p>✅ Atualizado para: " . esc_html($new_value) . "</p>";
    }
} else {
    echo "<p>✅ Nenhuma outra referência à URL antiga encontrada</p>";
}

// Verificar configurações atuais após correções
echo "<h2>✅ Configurações Finais:</h2>";
$wc_settings_final = get_option('woocommerce_pix_gateway_settings', array());
$api_url_final = get_option('wc_pix_gateway_api_url', '');

echo "<p><strong>URL no WooCommerce:</strong> " . esc_html($wc_settings_final['api_url'] ?? 'Não configurada') . "</p>";
echo "<p><strong>URL direta:</strong> " . esc_html($api_url_final ?: 'Não configurada') . "</p>";

// Testar se o gateway está funcionando
echo "<h2>🧪 Teste do Gateway:</h2>";
if (class_exists('WC_PIX_Gateway')) {
    $gateway = new WC_PIX_Gateway();
    echo "<p>✅ velozpay carregado com sucesso</p>";
    echo "<p><strong>URL configurada no gateway:</strong> " . esc_html($gateway->get_option('api_url', 'Não configurada')) . "</p>";
} else {
    echo "<p>❌ Classe WC_PIX_Gateway não encontrada</p>";
}

echo "<h2>📝 Próximos Passos:</h2>";
echo "<ol>";
echo "<li>Se foram feitas correções, desative e reative o plugin</li>";
echo "<li>Vá para WooCommerce > Configurações > Pagamentos > velozpay</li>";
echo "<li>Verifique se a URL da API está correta: <code>https://velozpay.online/api/v1/gateway/processa_pagamento_api.php</code></li>";
echo "<li>Salve as configurações</li>";
echo "<li>Teste um pagamento</li>";
echo "</ol>";

echo "<p><strong>⚠️ Importante:</strong> Após executar este script, delete este arquivo por segurança.</p>";
?>
